# eng38.inc
# scenario file for 1938 scenario
# Created by Andrew S. Davidson on 8 March 2005
# amended 20 Mar 2005 - peacetime_ic_mod added at high level and some OoB tweaks.
# 17-Sep-05 - reduce AA some more (they actually had lots in UK but AA is too good currently in the game)
#           - remove guarantees from 1939
#           - reduce manpower to 200 from 400
# 1 Oct-05  - reduce manpower to 100 to keep army small and make Cyprus national territory (along with Turkish/Greek claims)

province = { id =    9 ic = 4 } # Glasgow
province = { id =   10 ic = 3 } # Edinburgh
province = { id =   11 ic = 3 } # Sunderland
province = { id =   12 ic = 2 } # Blackpool
province = { id =   13 ic = 5 } # Sheffield
province = { id =   14 ic = 6 } # Liverpool
province = { id =   16 ic = 6 } # Birmingham
province = { id =   19 ic = 6 } # London
province = { id = 1465 ic = 2 } # Rajkot
province = { id = 1469 ic = 9 } # Delhi
province = { id = 1478 ic = 2 } # Bikaner
province = { id = 1479 ic = 3 } # Jodhpur
province = { id = 1505 ic = 2 } # Bombay
province = { id = 1513 ic = 2 } # Mangalore

province = { id = 20	landfort = 0 coastalfort = 3 }	#Dover
province = { id = 31	landfort = 0 coastalfort = 3 }	#Malta (has cliffs all around)
province = { id = 348	landfort = 6 coastalfort = 0 }	#Gibraltar
province = { id = 1315	landfort = 3 coastalfort = 1 }	#Hong Kong
province = { id = 1517	landfort = 0 coastalfort = 2 }	#Ceylon
province = { id = 1353	landfort = 0 coastalfort = 3 }	#Singapore

province = { id = 5	anti_air = 1 } #Scapa Flow
province = { id = 9	anti_air = 1 } #Glasgow
province = { id = 10	anti_air = 1 } #Edinburgh
province = { id = 11	anti_air = 1 } #Sunderland
province = { id = 12	anti_air = 1 } #Blackpool
province = { id = 13	anti_air = 1 } #Sheffield
province = { id = 14	anti_air = 1 } #Liverpool
province = { id = 15	anti_air = 1 } #Cardiff
province = { id = 16	anti_air = 1 } #Birmingham
province = { id = 17	anti_air = 1 } #Norwich
province = { id = 19  	anti_air = 2 } #London
province = { id = 20  	anti_air = 2 } #Dover
province = { id = 21	anti_air = 2 } #Portsmouth
province = { id = 22	anti_air = 1 } #Bristol
province = { id = 23	anti_air = 2 } #Plymouth
province = { id = 31	anti_air = 1 } #Malta
province = { id = 348	anti_air = 1 } #Gibraltar
province = { id = 900	anti_air = 1 } #Suez
province = { id = 906	anti_air = 1 } #Alexandria
province = { id = 1315	anti_air = 1 } #Hong Kong
province = { id = 1353	anti_air = 1 } #Singapore
province = { id = 1517	anti_air = 1 } #Colombo


province = { id = 5  radar_station = {  size = 1  current_size = 1  } } #Scapa Flow
province = { id = 9  radar_station = {  size = 1  current_size = 1  } } #Glasgow
province = { id = 10 radar_station = {  size = 1  current_size = 1  } } #Edinburgh
province = { id = 11 radar_station = {  size = 1  current_size = 1  } } #Sunderland
province = { id = 13 radar_station = {  size = 1  current_size = 1  } } #Sheffield
province = { id = 17 radar_station = {  size = 1  current_size = 1  } } #Norwich
province = { id = 20 radar_station = {  size = 2  current_size = 2  } } #Dover
province = { id = 21 radar_station = {  size = 1  current_size = 1  } } #Portsmouth

# Scapa Flow
province = { id = 5	air_base = { size = 2 current_size = 2	}
			naval_base = { size = 10 current_size = 10 } }
# Glasgow
province = { id = 9	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 10 current_size = 10 } }
# Sunderland
province = { id = 11	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6	current_size = 6 } }
# Sheffield
province = { id = 13	air_base = { size = 4 current_size = 4 }
			naval_base = { size = 2 current_size = 2 } }
# Liverpool
province = { id = 14	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6 current_size = 6 } }
# Birmingham
province = { id = 16	air_base = { size = 4 current_size = 4 } }

# Norwich
province = { id = 17	air_base = { size = 8 current_size = 8 }
			naval_base = { size = 1 current_size = 1 } }
# London
province = { id = 19	air_base = { size = 4 current_size = 4 } }

# Dover
province = { id = 20	air_base = { size = 8 current_size = 8 }
			naval_base = { size = 4 current_size = 4 } }
# Portmouth
province = { id = 21	air_base = { size = 4 current_size = 4 }
			naval_base = { size = 10 current_size = 10 } }
# Plymouth
province = { id = 23	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 10 current_size = 10 } }
# Belfast
province = { id = 28	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 4 current_size = 4 } }
# Malta
province = { id = 31	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 6	current_size = 6 } }
# Gibraltar
province = { id = 348	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 6 current_size = 6 } }
# Cyprus 
province = { id = 444	air_base = { size = 1 current_size = 1 } }

#Bermuda
province = { id = 538	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 1 current_size = 1 } }
# Andros
province = { id = 652	air_base = { size = 1 current_size = 1 } }

# Falklands
province = { id = 866	naval_base = { size = 1	current_size = 1 } }

# Georgetown
province = { id = 873	air_base = { size = 1 current_size = 1 } }

# Alexandria
province = { id = 906	air_base = { size = 4 current_size = 4 }
			naval_base = { size = 10 current_size = 10 } }
# Freetown
province = { id = 988	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 2	current_size = 2 } }
# Accra
province = { id = 1002	air_base = { size = 1 current_size = 1 } }

# Lagos
province = { id = 1008	air_base = { size = 1 current_size = 1 } }

# Mombasa
province = { id = 1061	air_base = { size = 1 current_size = 1 } }

# Khartoum
province = { id = 1066	air_base = { size = 1 current_size = 1 } }

# Mandalay
province = { id = 1296	air_base = { size = 1 current_size = 1 } }

#Rangoon
province = { id = 1299	air_base = { size = 1	current_size = 1 }
			naval_base = { size = 6 current_size = 6 } }
# Hong Kong
province = { id = 1315	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 6 current_size = 6 } }
# Singapore
province = { id = 1353	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 10 current_size = 10 } }
# Calcutta
province = { id = 1457	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6 current_size = 6 } }
# Indore
province = { id = 1467	air_base = { size = 1 current_size = 1 } }

# Delhi
province = { id = 1469	air_base = { size = 2 current_size = 2 } }

# Karachi
province = { id = 1494	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6	current_size = 6 } }
#Bombay
province = { id = 1505	air_base = { size = 2	current_size = 2 }
			naval_base = { size = 6 current_size = 6 } }
# Cochin
province = { id = 1514	air_base = { size = 1 current_size = 1 } }

# Trincomalee
province = { id = 1516	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 2 current_size = 2 } } 
#Columbo
province = { id = 1517	air_base = { size = 2 current_size = 2 }
			naval_base = { size = 6 current_size = 6 } }
# Kuching
province = { id = 1644	air_base = { size = 1 current_size = 1 } }

# Tel Aviv
province = { id = 1798	air_base = { size = 1 current_size = 1 } }

# Aden
province = { id = 1813	naval_base = { size = 1 current_size = 1 } }

#Diego Garcia
province = { id = 1817	air_base = { size = 1 current_size = 1 }
			naval_base = { size = 1 current_size = 1 } }

province = {  id = 1100		oilpool = 100	supplypool = 500 }	# Egypt (Port Said)
province = {  id = 1459		oilpool = 100	supplypool = 500 }	# India (Bombay)
province = {  id = 348		oilpool = 200	supplypool = 500 }	# Gibraltar
province = {  id = 1353		oilpool = 1000	supplypool = 5000 }	# Singapore
province = {  id = 31		oilpool = 100	supplypool = 500 }	# Malta
province = {  id = 1315		oilpool = 100	supplypool = 500 }	# Hong Kong
province = {  id = 1517		oilpool = 1000	supplypool = 2000 }	# Ceylon
province = {  id = 538		oilpool = 100	supplypool = 500 }	# Bermuda
province = {  id = 988		oilpool = 1000	supplypool = 2000 }	# Freetown
province = {  id = 28		oilpool = 1000	supplypool = 2000 }	# Belfast
province = {  id = 866		oilpool = 100	supplypool = 200 }	# Falklands
province = {  id = 1817		oilpool = 100	supplypool = 200 }	# Diego Garcia

country = { tag = ENG
	capital = 19
	policy = { date = { year = 0 month = january day = 0 }
	        democratic		= 10
        	political_left		= 2
	        freedom			= 9
        	free_market		= 8
	        professional_army	= 8 # no conscription
        	defense_lobby		= 6
	        interventionism 	= 6
	    	}

	headofstate		= { type = 9 id = 1033 }
	headofgovernment	= { type = 9 id = 1037 }
 	foreignminister		= { type = 9 id = 1003 }
 	armamentminister	= { type = 9 id = 1163 }
 	ministerofsecurity	= { type = 9 id = 1083 }
 	ministerofintelligence	= { type = 9 id = 1006 }
 	chiefofstaff		= { type = 9 id = 1117 }
 	chiefofarmy		= { type = 9 id = 1128 }
 	chiefofnavy		= { type = 9 id = 1137 }
 	chiefofair		= { type = 9 id = 1149 }

	dormant_ministers = { 1001 1031 1002 1004 1081 1007 1008 1127 1009 1010 1082 }

	peacetime_ic_mod = 0.4  # 1938 expenditure on war was actually less than one sixth of the level once war started
				# this level allows the capital naval program to be fully built but little else
				# this may help stop UK starting the war with a huge army, which upsets people
	energy		= 10000   
	oil		= 10000	
	manpower	= 100
	metal		= 10000		
	money		= 1000
	rare_materials	= 10000	
	supplies	= 1000
	transports 	= 1200
	escorts 	= 150

	ai = "ENG_1936.ai"

	ownedprovinces =      {
		# GREAT BRITAIN
		3 5 6 7 8 9 10 11 12 13 14 15 16 17 19 20 21 22 23
		575 576	# Newfoundland
		28 29	# N.Ireland
		348	# Gibraltar
		31	# Malta
		444	# Cyprus
		# INDIA
		1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1877 1878
		1469 1470 1471 1472 1456 1468 1467 1464 1463 1474
		1460 1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510
		1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285
		1286 1287 1288 1289 1290 1291 1898 1304 1295 1296
		1301 1302 1346 1299 1298 1297 1300 1292 1454
		# MIDDLE-EAST
		1799 1798 1797 1796 404 1802 1803 406 407
		1813 1814	# Aden Protectorate
		1504 1820	# Trucial States
		# SOUTHEAST ASIA
		1349 1350 1351 1352 1353 # Malay States
		1644 1646 1647		 # Sarawak-Borneo
		1315			 # Hong Kong
		# CARRIBEAN
		758 			# Belize
		891 			# Jamaica
		871 873 		# Br.Guyana
		806 807 808 809 897 	# Br. West Indies
		538 			# Bermuda
		652 653 664 665 666 668 # The Bahamas
		805			# St.Lucia
		896			# Virgin Islands
		# MISC
		866  			# Falklands
		1147 			# Ascension
		1148 			# St.Helena
		1816 			# Seychelles
		1817 			# Diego Garcia
		1136 			# Mauritius
		1815 			# Sokotra
		# EAST AFRICA
		1132 			# Malawi
		1139 1062 1140 1141 1064 1060 1061 1059 #Br.East Africa
		1035 1036 		# Br.Somaliland
		# SOUTH AFRICA
		1112 1111 1105 		# Bechuanaland
		1124 1125 		# South Rhodesia
		1104 1099 1129 1126 1128 # North Rhodesia
		# WEST AFRICA
		1000 1001 1002		# Gold Coast
		1008 1007 999 1009 1010 1011 1145 1085 1012 # Nigeria
		988 			# Sierra Leone
		982 			# Gambia
		# PACIFIC
		1622 1683 1684 1685 1686
		1763
		1761 1767 1768 1769 1770
		1757 1759 1760
		1752 1753 1754 1755 1758
		#EGYPT
		900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915
		4 1020 1019 1021 1022 1027 1023 1026 1024 1025 1800 1801
		#SUDAN
		1065 1066 1069 1068 1067 1029 1028 1032 1031 1030 1040 1041
		1614 1611
	}

	controlledprovinces = {
		#GREAT BRITAIN
		3 5 6 7 8 9 10 11 12 13 14 15 16 17 19 20 21 22 23
		575 576 #Newfoundland
		28 29 #N.Ireland
		348 #Gibraltar
		31 #Malta
		444 #Cyprus
		#INDIA
		1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477  1877  1878
		1469 1470 1471 1472 1456 1468 1467 1464 1463 1474
		1460 1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510
		1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285
		1286 1287 1288 1289 1290 1291 1898 1304 1295 1296
		1301 1302 1346 1299 1298 1297 1300 1292 1454
		#MIDDLE-EAST
		1799 1797 1796 404 1802 1803 406 407
		1813 1814 #Aden Protectorate
		1504 1820#Trucial States
		1798
		#SOUTHEAST ASIA
		1349 1350 1351 1352 1353 #Malay States
		1644 1646 1647 #Sarawak-Borneo
		1315 #Hong Kong
		# CARRIBEAN
		758 #Belize
		891 #Jamaica
		871 873 #Br.Guyana
		806 807 808 809 897 #Br. West Indies
		538 #Bermuda
		652 653 664 665 666 668 #The Bahamas
		805
		896
		# MISC
		866  #Falklands
		1147 #Ascension
		1148 #St.Helena
		1816 #Seychelles
		1817 #Diego Garcia
		1136 #Mauritius
		1815 # Sokotra
		# EAST AFRICA
		1139 1062 1140 1141 1064 1060 1061 1059 #Br.East Africa
		1132 #Malawi
		1035 1036 #Br.Somaliland
		# SOUTH AFRICA
		1112 1111 1105 #Bechuanaland
		1124 1125 #South Rhodesia
		1104 1099 1129 1126 1128 #North Rhodesia
		# WEST AFRICA
		1000 1001 1002 #Gold Coast
		1008 1007 999 1009 1010 1011 1145 1085 1012 #Nigeria
		988 #Sierra Leone
		982 #Gambia
		# PACIFIC
		1622 1683 1684 1685 1686
		1763
		1761 1767 1768 1769 1770
		1757 1759 1760
		1752 1753 1754 1755 1758
		#EGYPT
		900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915

		4 1020 1019 1021 1022 1027 1023 1026 1024 1025 1800 1801
		#SUDAN
		1065 1066 1069 1068 1067 1029 1028 1032 1031 1030 1040 1041
		1614 1611
				}

	nationalprovinces =   {
		#GREAT BRITAIN
		3 5 6 7 8 9 10 11 12 13 14 15 16 17 19 20 21 22 23
		28 29 	# N.Ireland
		348	# Gibraltar
		31 	# Malta
		444	# Cyprus - annexed by the British Empire in 1913 and UK still has sovereign bases there
		#INDIA
		1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477  1877  1878
		1469 1470 1471 1472 1456 1468 1467 1464 1463 1474
		1460 1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510
		1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285
		1286 1287 1288 1289 1290 1291 1898 1304 1295 1296
		1301 1302 1346 1299 1298 1297 1300 1292 1454
				}

diplomacy = {
relation = { tag = AFG value = -75 }
relation = { tag = ARG value = 75 }
relation = { tag = AST value = 200 }
relation = { tag = BEL value = 150 }
relation = { tag = BHU value = 200}
relation = { tag = BUL value = 20 }
relation = { tag = CAN value = 200 }
relation = { tag = CHI value = 100 }
relation = { tag = CZE value = 50 }
relation = { tag = DEN value = 100 }
relation = { tag = EST value = 50 }
relation = { tag = FIN value = 85 }
relation = { tag = FRA value = 150 }
relation = { tag = GER value = -100 }
relation = { tag = GRE value = 50 }
relation = { tag = GUA value = 50 }
relation = { tag = HOL value = 125 }
relation = { tag = HUN value = 0 }
relation = { tag = IRE value = 50 }
relation = { tag = IRQ value = 100 access = yes guaranteed = { day = 11 month = february year = 1930 }}
relation = { tag = ITA value = -50 }
relation = { tag = JAP value = -50 }
relation = { tag = MEX value = 50 }
relation = { tag = NEP value = 200 }
relation = { tag = NOR value = 90 }
relation = { tag = NZL value = 200 }
relation = { tag = OMN value = 150 }
relation = { tag = PER value = 25 }
relation = { tag = POL value = 100 }
relation = { tag = POR value = 100 }
relation = { tag = ROM value = 50  }
relation = { tag = SAF value = 200 }
relation = { tag = SAU value = 100 guaranteed = { day = 11 month = february year = 1934 } }
relation = { tag = SCH value = 50   }
relation = { tag = SIA value = 70 }
relation = { tag = SOV value = -100 }
relation = { tag = SPA value = -50 }
relation = { tag = SPR value = 0 }
relation = { tag = SWE value = 80 }
relation = { tag = TUR value = 75  guaranteed = { day = 17 month = may year = 1938 } }
relation = { tag = USA value = 100 }
relation = { tag = VEN value = -10 }
relation = { tag = YEM value = 150 guaranteed = { day = 11 month = february year = 1934 } }

}

techapps = {
1010 # Great War Infantry
1020 # Early Infantry
1110 # Basic Mountain
1150 # Basic Marine
1190 # Great War Cavalry Division
1200 # Early Cavalry Division
1210 # Basic Cavalry Division
1220 # Semi-motorised Cavalry
1230 # Basic Motorized Infantry
1310 # Rear Area Supply Dumps
1340 # Rear Area Vehicle Repair Shop
2010 # Great War Tank
2020 # Tankette
2030 # Early Tank
2040 # Basic Light Tank
2150 # Basic Armoured Car
2290 # Great War Light Field Artillery
2300 # Great War Medium Field Artillery
2310 # Great War Heavy Field Artillery
2320 # Early Field Artillery
2330 # Basic Artillery
2400 # Basic AT
2450 # Great War Static Anti-Air Artillery
2460 # Early Static AA
2510 # Basic AA
3010 # Great War Destroyer
3020 # Early Destroyer
3030 # Basic Destroyer
3070 # Great War Light Cruiser
3080 # Early Light Cruiser
3090 # Basic Light Cruiser
3100 # Improved Light Cruiser
3130 # Great War Heavy Cruiser
3140 # Early Heavy Cruiser
3150 # Basic Heavy Cruiser
3190 # Great War Battlecruiser
3200 # Early Battlecruiser
3210 # Basic Battlecruiser
3250 # Great War Battleship
3260 # Early Battleship
3270 # Basic Battleship
3280 # Improved Battleship
3320 # Great War Air Carrier
3330 # Early Air Carrier
3340 # Basic Air Carrier
3350 # Imp. Air Carrier
3400 # Dive Boat
3410 # Short Range Submarine
3420 # Medium Range Submarine
4010 # Interwar Fighter
4020 # Early Fighter
4030 # Basic Interceptor
4120 # Interwar Bomber
4130 # Early Bomber
4140 # Basic Tactical Bomber
4190 # Basic Naval Bomber
4220 # Basic Strategic Bomber
5010 # Modern Agriculture
5020 # Mechanized Agriculture
5030 # Agrichemistry
5050 # Basic Machine Tools
5080 # Basic Construction Engineering
5090 # Improved Construction Engineering
5190 # Basic Oil Refining
5200 # Improved Oil Refining
5310 # Census Tabulating Machine
5320 # Basic Computing Machine
5350 # Basic Encryption Devices
5360 # Basic Decryption Devices
5410 # Basic Decimetric Radar Warning Sites
5470 # Faculty of Atomic Research
5480 # Atomic Research Laboratories
5490 # Faculty of Nuclear Research
6010 # Firepower Focus Doctrine
6030 # Grand Battle Plan Doctrine
6110 # Mass Assault Doctrine
6120 # Trench Warfare Doctrine
8010 # Decisive Battle Doctrine
8020 # Naval Firepower Doctrine
8030 # Fleet Auxiliary Carrier Doctrine
8040 # Fleet Auxiliary Submarine Doctrine
8050 # Convoy Sailing Doctrine
8070 # Fleet-in-Being Doctrine
8120 # Battlefleet Concentration Doctrine
8310 # Floating Fortress Doctrine
9010 # Air Superiority Doctrine
9020 # Flying Circus Doctrine
9030 # Force Substitution Doctrine
9090 # Operational Destruction Doctrine
9140 # Strategic Destruction Doctrine
	}

landunit = { location = 22  id = { type = 13016 id = 1 }	name = "Aldershot Command"
		division = { experience = 35 id = { type = 13016 id = 1111 }	name = "Army HQ"
				type = hq strength  = 100 model = 1 }
		division = { experience = 20 id = { type = 13016 id = 2 } name = "1st Infantry Division"
				type = infantry strength = 80 model = 2	extra = anti_air brigade_model = 1}
		division = { experience = 20 id = { type = 13016 id = 3 } name = "2nd Infantry Division"
				type = infantry	strength = 80 model = 2 extra = engineer } }

landunit = { location = 20 id = { type = 13016 id = 4 }		name = "Eastern Command - Regulars"
		division = { experience = 20 id = { type = 13016 id = 5 }	name = "4th Infantry Division"
				type = infantry	strength = 75 model = 1 extra = artillery brigade_model = 2} }

landunit = { location = 17 id = { type = 13016 id = 54 }		name = "Eastern Command - E.Anglia"
		division = { experience = 20 id = { type = 13016 id = 6 }	name = "12th 'Eastern' Division"
				type = garrison strength = 50 model = 0 locked = yes}
		division = { experience = 20 id = { type = 13016 id = 9 }	name = "54th 'East Anglia' Division"
				type = garrison	strength = 50 model = 0 } }

landunit = { location = 20 id = { type = 13016 id = 55 }		name = "Eastern Command - Kent"
		division = { experience = 20 id = { type = 13016 id = 7 }	name = "18th Infantry Division"
				type = garrison	strength = 60 model = 0 extra = anti_air brigade_model = 1}
		division = { experience = 15 id = { type = 13016 id = 8 }	name = "44th 'Home Counties' Division"
				type = garrison	strength = 50 model = 0 locked = yes} }

landunit = { location = 19 id = { type = 13016 id = 10 }	name = "London District"
		division = { experience = 35 id = { type = 13016 id = 11 }	name = "47th 'London' Division"
				type = garrison strength = 60 model = 0 extra = artillery brigade_model = 2}
		division = { experience = 35 id = { type = 13016 id = 12 }	name = "56th 'London' Division"
				type = garrison	strength = 50 model = 0 locked = yes} }

landunit = { location = 11 id = { type = 13016 id = 13 } 	name = "Northern Command - Regulars"
		division = { experience = 20 id = { type = 13016 id = 14 }	name = "5th Infantry Division"
				type = infantry	strength = 70 model = 1 extra = artillery brigade_model = 2} }

landunit = { location = 11 id = { type = 13016 id = 51 } 	name = "Northern Command - N.Yorks"
		division = { experience = 15 id = { type = 13016 id = 15 }	name = "49th 'West Riding' Division"
				type = garrison	strength = 50 model = 0 locked = yes extra = engineer } }

landunit = { location = 13 id = { type = 13016 id = 52} 	name = "Northern Command - S.Yorks"
		division = { experience = 15 id = { type = 13016 id = 16 }	name = "46th 'North Midlands' Division"
				type = garrison	strength = 50 model = 0 locked = yes extra = anti_air brigade_model = 1} }

landunit = { location = 12 id = { type = 13016 id = 53 } 	name = "Northern Command - Borders"
		division = { experience = 20 id = { type = 13016 id = 17 }	name = "23th 'Northumbrian' Division"
				type = garrison	strength = 50 model = 0 }
		division = { experience = 20 id = { type = 13016 id = 18 }	name = "50th 'Northumbrian' Division"
				type = garrison	strength = 50 model = 0 locked = yes} }

landunit = { location = 9 id = { type = 13016 id = 19 }		name = "Scottish Command - West Coast"
		division = { experience = 35 id = { type = 13016 id = 20 }	name = "9th 'Scottish' Division"
				type = garrison strength = 50 model = 0 locked = yes extra = artillery brigade_model = 2}}

landunit = { location = 10 id = { type = 13016 id = 50 }		name = "Scottish Command - East Coast"
		division = { experience = 45 id = { type = 13016 id = 21 }	name = "51st 'Highland' Division"
				type = garrison strength = 70 model = 0 locked = yes extra = engineer} }

landunit = { location = 21 id = { type = 13016 id = 22 }	name = "Southern Command - Regulars"
		division = { experience = 20 id = { type = 13016 id = 23 }	name = "3rd Infantry Division"
				type = infantry	strength = 75 model = 1 extra = engineer}
		division = { experience = 15 id = { type = 13016 id = 24 }	name = "1st Armoured Division"
				type = light_armor strength = 10 model = 0 } }

landunit = { location = 22 id = { type = 13016 id = 58 }	name = "Southern Command - South Mids"
		division = { experience = 15 id = { type = 13016 id = 25 }	name = "48th 'South Midlands' Division"
				type = garrison strength = 60 locked = yes model = 0 } }

landunit = { location = 23 id = { type = 13016 id = 59 }	name = "Southern Command - W.Country"
		division = { experience = 15 id = { type = 13016 id = 27 }	name = "43rd 'Wessex' Division"
				type = garrison	strength = 50 model = 0 locked = yes extra = anti_air brigade_model = 1} }

landunit = { location = 21 id = { type = 13016 id = 60 }	name = "Southern Command - Hants"
		division = { experience = 10 id = { type = 13016 id = 26 }	name = "61st Infantry Division"
				type = garrison	strength = 50 model = 0 extra = artillery brigade_model = 2}
		division = { experience = 15 id = { type = 13016 id = 28 }	name = "45th Infantry Division"
				type = garrison	strength = 50 model = 0 locked = yes} }

landunit = { location = 14 id = { type = 13016 id = 29 } 	name = "Western Command - Lancs"
		division = { experience = 15 id = { type = 13016 id = 30 }	name = "55th 'West Lancashire' Division"
				type = garrison strength = 50 model = 0 extra = anti_air brigade_model = 1}
		division = { experience = 15 id = { type = 13016 id = 31 }	name = "42nd 'East Lancashire' Division"
				type = garrison strength = 50 model = 0 locked = yes extra = artillery brigade_model = 2} }

landunit = { location = 15 id = { type = 13016 id = 56 } 	name = "Western Command - Wales"
		division = { experience = 15 id = { type = 13016 id = 33 }	name = "38th 'Welsh' Division"
				type = garrison	strength = 50 model = 0 }
		division = { experience = 15 id = { type = 13016 id = 34 }	name = "53rd 'Welsh' Division"
				type = garrison	strength = 50 model = 0	} }

landunit = { location = 16 id = { type = 13016 id = 57 } 	name = "Western Command - West Mids"
		division = { experience = 15 id = { type = 13016 id = 32 }	name = "66th Infantry Division"
				type = garrison	strength = 50 model = 0 } }

landunit = { location = 1007 id = { type = 13016 id = 424 } 	name = "Royal West African Frontier Force"
		division = { experience = 15 id = { type = 13016 id = 425 }	name = "Nigeria, Gambia & Gold Coast Regiments"
				type = bergsjaeger	strength = 30  } } # light infantry with african porters not mules

landunit = { location = 1315 id = { type = 13016 id = 35 }	name = "Hong Kong Command"
		division = { experience = 35 id = { type = 13016 id = 36 }	name = "Hong Kong Brigade"
				type = garrison	model = 0 strength = 100 locked = yes extra = artillery brigade_model = 2} }

landunit = { location = 1353 id = { type = 13016 id = 37 }			name = "Malaya Command"
		division = { experience = 35 id = { type = 13016 id = 38 }	name = "Singapore Fortress"
				type = garrison	model = 0 strength = 100 locked = yes extra = anti_air brigade_model = 1} }

landunit = { location = 348  id = { type = 13016 id = 39 }	name = "Gibraltar Command"
		division = { experience = 45 id = { type = 13016 id = 40 }	name = "Gibraltar Defence Force"
				type = garrison	model = 0 strength = 100 locked = yes extra = artillery brigade_model = 2} }

landunit = { location = 31 id = { type = 13016 id = 41 }	name = "Malta Command"
		division = { experience = 35 id = { type = 13016 id = 42 }	name = "Malta Defence Force"
				type = garrison	model = 0 strength = 100 locked = yes extra = artillery brigade_model = 2} }

landunit = { location = 1517 id = { type = 13016 id = 43 }	name = "Ceylon Command"
		division = { experience = 35 id = { type = 13016 id = 44 }	name = "Ceylon Defence Force"
				type = garrison	locked = yes model = 0 strength = 100 } }

landunit = { location = 538 id = { type = 13016 id = 45 }	name = "Bermuda Command"
		division = { experience = 35 id = { type = 13016 id = 46 }	name = "Bermuda Volunteer Rifle Corps"
				type = garrison	locked = yes strength = 100 model = 0} }

landunit = { location = 911 id = { type = 13016 id = 47 }	name = "Middle East Command"
		division = { experience = 15 id = { type = 13016 id = 48 }	name = "7th Infantry Division"
				type = motorized strength = 50 model = 0
				extra = artillery brigade_model = 3 }
		division = { experience = 35 id = { type = 13016 id = 49}	name = "The Armoured Division"
				type = light_armor strength = 50 model = 0 } }

landunit = { location = 1483 id = { type = 13016 id = 300 }	name = "Peshawar District"
		division = { experience = 40 id = { type = 13016 id = 301 }	name = "Ghurka Rifles"
				type = bergsjaeger strength = 100 model = 0 } }

landunit = { location = 1474 id = { type = 13016 id = 302 }	name = "Rawalpindi District"
		division = { experience = 40 id = { type = 13016 id = 303 }	name = "Ghurka Rifles"
				type = bergsjaeger strength = 100 model = 0 } 
		division = { experience = 40 id = { type = 13016 id = 304 }	name = "Ghurka Rifles"
				type = bergsjaeger strength = 100 model = 0 } }

landunit = { location = 1475 id = { type = 13016 id = 305 }	name = "Lahore District"
		division = { experience = 25 id = { type = 13016 id = 306 }	name = "Royal Lancers"
				type = cavalry strength  = 100 model = 1 
                                extra = armored_car brigade_model = 0 } }

landunit = { location = 1482 id = { type = 13016 id = 307 }	name = "Waziristan District"
		division = { experience = 25 id = { type = 13016 id = 308 }	name = "Sikh Regiment"
				type = infantry	strength  = 100 model = 0 } }

landunit = { location = 1477 id = { type = 13016 id = 309 }	name = "Meerut District"
		division = { experience = 25 id = { type = 13016 id = 310 }	name = "Garhwal Rifles"
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1471 id = { type = 13016 id = 311 }	name = "Lucknow District"
		division = { experience = 25 id = { type = 13016 id = 312 }	name = "Punjab Regiment"
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1457 id = { type = 13016 id = 313 }	name = "Presidency District"
		division = { experience = 25 id = { type = 13016 id = 314 }	name = "Assam Rifles"
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1506 id = { type = 13016 id = 315 }	name = "Poona District"
		division = { experience = 25 id = { type = 13016 id = 316 }	name = "Rajputana Rifles"
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1505 id = { type = 13016 id = 317 }	name = "Bombay District"
		division = { experience = 25 id = { type = 13016 id = 318 }	name = "Mahtratta Light Infantry"
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1511 id = { type = 13016 id = 319 }	name = "Madras District"
		division = { experience = 25 id = { type = 13016 id = 320 }	name = "Rajput Regiment"
				type = infantry	strength = 100 model = 0 } }

landunit = { location = 1066 id = { type = 13016 id = 400 }	name = "Sudanese Defense Force" 
		division = { experience = 10 id = { type = 13016 id = 401 }	name = "Shendi Horse and Arab Corps"
				type = cavalry strength = 30 model = 0} }

landunit = { location = 1813 id = { type = 13016 id = 402 }	name = "Aden Protectorate" 
		division = { experience = 10 id = { type = 13016 id = 403 }	name = "Lahej Trained Forces"
				type = garrison locked = yes strength = 30 }	}

landunit = { location = 1035 id = { type = 13016 id = 404 }	name = "Somaliland"
		division = { experience = 10 id = { type = 13016 id = 405 }	name = "Camel Corps"
				type = cavalry strength = 10 model = 0} }

landunit = { location = 1060 id = { type = 13016 id = 406 }	name = "Uganda Territorial Force"
		division = { experience = 10 id = { type = 13016 id = 407 }	name = "King's African Rifles"
				type = militia strength = 10 }	}

landunit = { location = 1062 id = { type = 13016 id = 410 }	name = "The Northern Brigade"
		division = { experience = 10 id = { type = 13016 id = 411 }	name = "King's African Rifles"
				type = militia strength = 100 }	}

landunit = { location = 1140 id = { type = 13016 id = 412 }	name = "The Kenya Regiment"
		division = { experience = 10 id = { type = 13016 id = 413 }	name = "King's African Rifles"
				type = militia strength = 100 }	}

landunit = { location = 1139	id = { type = 13016 id = 414 }	name = "The Southern Brigade"
		division = { experience = 10 id = { type = 13016 id = 415 }	name = "King's African Rifles"
				type = militia strength = 100 }	}

landunit = { location = 1299 id = { type = 13016 id = 418 }	name = "Rangoon Brigade"
		division = { experience = 15 id = { type = 13016 id = 419 }	name = "1st Burma Rifles"
				type = infantry	strength = 100 model = 0} }

landunit = { location = 1296 id = { type = 13016 id = 423 }	name = "Maymyo Brigade"
		division = { experience = 15 id = { type = 13016 id = 420 }	name = "2nd Burma Rifles"
				type = infantry strength = 100 model = 0} }

landunit = { location = 1797 id = { type = 13016 id = 421 }	name = "Palestine and Transjordan"
		division = { experience = 35 id = { type = 13016 id = 61 }	name = "8th Infantry Division"
				type = motorized strength = 80
				extra = armored_car } }
navalunit = { 
	name = "Home Fleet"
	location = 5 
	base = 5
	id = { type = 13016 id = 500 }	
	division = { id = { type = 13016 id = 501 } name = "HMS Nelson" type = battleship model = 2 }
	division = { id = { type = 13016 id = 502 } name = "HMS Rodney" type = battleship model = 2 }
	division = { id = { type = 13016 id = 503 } name = "HMS Royal Oak" type = battleship model = 1 }
	division = { id = { type = 13016 id = 504 } name = "HMS Royal Sovereign" type = battleship model = 1 }
	division = { id = { type = 13016 id = 505 } name = "HMS Ramillies" type = battleship model = 1 }
	division = { id = { type = 13016 id = 510 } name = "HMS Furious" type = carrier model = 1 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 526 } name = "HMS Norfolk" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 641 } name = "HMS Suffolk" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 515 } name = "HMS Effingham" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 512 } name = "HMS Sheffield" type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 511 } name = "HMS Aurora" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 577 } name = "HMS Achilles" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 600 } name = "HMS Leander" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 516 } name = "HMS Emerald" type = light_cruiser model = 1 }
	division = { id = { type = 13016 id = 517 } name = "HMS Enterprise" type = light_cruiser model = 1 }
	division = { id = { type = 13016 id = 521 } name = "HMS Diomede" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 524 } name = "HMS Calypso" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 525 } name = "HMS Calcutta" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 519 } name = "HMS Cardiff" type = light_cruiser model = 0  }
	division = { id = { type = 13016 id = 520 } name = "HMS Delhi" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 568 } name = "1st Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 566 } name = "2nd Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 561 } name = "3rd Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 562 } name = "4th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 564 } name = "5th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 528 } name = "6th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 529 } name = "7th Destroyer Flotilla" type = destroyer model = 2 }
	division = { id = { type = 13016 id = 530 } name = "8th Destroyer Flotilla" type = destroyer model = 2 }
	division = { id = { type = 13016 id = 576 } name = "9th Destroyer Flottila" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 575 } name = "10th Destroyer Flotilla" type = destroyer model = 1 }
	}

navalunit = { 
	name = "Battlecruiser squadron"
	location = 5 
	base = 5
	id = { type = 13016 id = 499 }	
	division = { id = { type = 13016 id = 506 } name = "HMS Hood" type = battlecruiser model = 2 }
	division = { id = { type = 13016 id = 507 } name = "HMS Repulse" type = battlecruiser model = 1 }
	division = { id = { type = 13016 id = 508 } name = "HMS Renown" type = battlecruiser model = 1 }
	division = { id = { type = 13016 id = 509 } name = "HMS Ark Royal" type = carrier model = 2 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 527 } name = "HMS Newcastle" type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 513 } name = "HMS Edinburgh" type = light_cruiser model = 3 }
	}

navalunit = {
	name = "Reserve Fleet"
	id = { type = 13016 id = 560 }
	location = 5 #Scapa Flow
	base = 5
	division = { id = { type = 13016 id = 701 }  name = "HMS Argus" type = carrier model = 0
						extra = cag brigade_model = 2 }
	division = { id = { type = 13016 id = 563 } name = "HMS Queen Elizabeth" type = battleship model = 1 }
	division = { id = { type = 13016 id = 565 } name = "HMS Valiant" type = battleship model = 1 }
	division = { id = { type = 13016 id = 567 } name = "HMS Frobisher" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 569 } name = "HMS Hawkins" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 574 } name = "HMS London" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 635 } name = "HMS Carlisle" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 640 } name = "HMS Curacoa" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 522 } name = "HMS Dragon" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 518 } name = "HMS Dunedin" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 523 } name = "HMS Caledon" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 642 } name = "HMS Curlew" type = light_cruiser model = 0 }
	}

navalunit = {
	name = "2nd Submarine Squadron"
	id = { type = 13016 id = 531 }
	location = 5
	base = 5
	division = { id = { type = 13016 id = 532 } name = "5th Submarine Flotilla" type = submarine model = 1 }
	division = { id = { type = 13016 id = 533 } name = "6th Submarine Flotilla" type = submarine model = 1 }
	division = { id = { type = 13016 id = 534 } name = "7th Submarine Flotilla" type = submarine model = 1 }
	}

navalunit = {
	name = "5th Submarine Squadron"
	id = { type = 13016 id = 535 }
	location = 5
	base = 5
	division = { id = { type = 13016 id = 536 } name = "12th Submarine Flotilla" type = submarine model = 1 }
	}

navalunit = {
	name = "1st Transport Squadron"
	id = { type = 13016 id = 537 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 538 } name = "1st Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 539 } name = "2nd Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 5660 } name = "3rd Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 5661 } name = "4th Transport Flotilla" type = transport model = 0 }
	}

navalunit = {
	name = "Channel Force"
	id = { type = 13016 id = 540 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 541 } name = "HMS Resolution" type = battleship model = 1 }
	division = { id = { type = 13016 id = 542 } name = "HMS Revenge" type = battleship model = 1 }
	division = { id = { type = 13016 id = 543 } name = "HMS Courageous" type = carrier model = 1 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 544 } name = "HMS Hermes" type = carrier model = 0 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 545 } name = "HMS Ceres" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 546 } name = "HMS Caradoc" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 547 } name = "HMS Cairo" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 548 } name = "11th Destroyer Flotilla" type = destroyer model = 0 }
	division = { id = { type = 13016 id = 570 } name = "12th Destroyer Flotilla" type = destroyer model = 1 }
	}

navalunit = {
	name = "4th Submarine Squadron"
	id = { type = 13106 id = 549 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 550 } name = "10th Submarine Flotilla" type = submarine model = 1 }
	division = { id = { type = 13016 id = 551 } name = "11th Submarine Flotilla" type = submarine model = 2 }
	}

navalunit = {
	name = "2nd Transport Squadron"
	id = { type = 13016 id = 552 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 553 } name = "5th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 554 } name = "6th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 5662 } name = "7th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 5663 } name = "8th Transport Flotilla" type = transport model = 0 }
	}

navalunit = {
	name = "Monitors"
	id = { type = 13016 id = 5666 }
	location = 21 #Portsmouth
	base = 21
	division = { id = { type = 13016 id = 5667 } name = "HMS Terror" type = battleship model = 0 maxspeed = 10 							seaattack = 6 seadefence = 6 shorebombardment = 8 }
	division = { id = { type = 13016 id = 5668 } name = "HMS Erebus" type = battleship model = 0 maxspeed = 10
							seaattack = 6 seadefence = 6 shorebombardment = 8 }
	}

navalunit = {
	name = "Humber Force"
	id = { type = 13016 id = 555 }
	location = 13
	base = 13
	division = { id = { type = 13016 id = 514 } name = "HMS Belfast" type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 556 } name = "HMS Southampton" type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 557 } name = "HMS Glasgow" type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 558 } name = "13th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 559 } name = "14th Destroyer Flotilla" type = destroyer model = 1 }
	}

navalunit = {
	name = "17th Destroyer Squadron"
	id = { type = 13016 id = 571 }
	location = 23 #Plymouth
	base = 23
	division = { id = { type = 13016 id = 572 } name = "15th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 573 } name = "16th Destroyer Flotilla" type = destroyer model = 0 }
	}

navalunit = {
	name = "Mediterranean Fleet"
	id = { type = 13016 id = 579 }
	location = 906 #Alexandria
	base = 906
	division = { id = { type = 13016 id = 580 } name = "HMS Warspite" type = battleship model = 1 }
	division = { id = { type = 13016 id = 581 } name = "HMS Barham" type = battleship model = 1 }
	division = { id = { type = 13016 id = 582 } name = "HMS Malaya" type = battleship model = 1 }
	division = { id = { type = 13016 id = 583 } name = "HMS Glorious" type = carrier model = 1 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 584 } name = "HMS Devonshire" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 585 } name = "HMS Shropshire" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 586 } name = "HMS Sussex" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 587 } name = "HMS Arethusa" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 588 } name = "HMS Penelope" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 589 } name = "HMS Galatea" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 590 } name = "HMS Coventry" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 591 } name = "17th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 592 } name = "18th Destroyer Flotilla" type = destroyer model = 0 }
	division = { id = { type = 13016 id = 593 } name = "19th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 594 } name = "20th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 595 } name = "21st Destroyer Flotilla" type = destroyer model = 0 }
	division = { id = { type = 13016 id = 596 } name = "22nd Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 597 } name = "23rd Destroyer Flotilla" type = destroyer model = 1 }
}

navalunit = {
	name = "1st Submarine Squadron"
	id = { type = 13016 id = 598 }
	location = 906 #Alexandria
	base = 906
	division = { id = { type = 13016 id = 599 } name = "1st Submarine Flotilla" type = submarine model = 2 }
	division = { id = { type = 13016 id = 903 } name = "2nd Submarine Flotilla" type = submarine model = 0 }
	division = { id = { type = 13016 id = 900 } name = "3rd Submarine Flotilla" type = submarine model = 2 }
	division = { id = { type = 13016 id = 902 } name = "4th Submarine Flotilla" type = submarine model = 2 }
	}

navalunit = {
	name = "3rd Transport Squadron"
	id = { type = 13016 id = 601 }
	location = 906 #Alexandria
	base = 906
	division = { id = { type = 13016 id = 602 } name = "9th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 603 } name = "10th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 5664 } name = "11th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 5665 } name = "12th Transport Flotilla" type = transport model = 0 }
	}

navalunit = {
	name = "4th Transport Squadron"
	id = { type = 13016 id = 9879 }
	location = 20 #Dover
	base = 20
	division = { id = { type = 13016 id = 9880 } name = "13th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 9881 } name = "14th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 9882 } name = "15th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 9883 } name = "16th Transport Flotilla" type = transport model = 0 }
	}

navalunit = {
	name = "5th Transport Squadron"
	id = { type = 13016 id = 9884 }
	location = 23 #Plymouth
	base = 23
	division = { id = { type = 13016 id = 9885 } name = "17th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 9886 } name = "18th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 9887 } name = "19th Transport Flotilla" type = transport model = 0 }
	division = { id = { type = 13016 id = 9888 } name = "20th Transport Flotilla" type = transport model = 0 }
	}

navalunit = {
	name = "North Atlantic Command"
	id = { type = 13016 id = 604 }
	location = 348 #Gibraltar
	base = 348
	division = { id = { type = 13016 id = 605 } name = "HMS Colombo" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 606 } name = "HMS Capetown" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 607 } name = "24th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 608 } name = "25th Destroyer Flotilla" type = destroyer model = 1 }
	}

navalunit = {
	name = "South Atlantic Command"
	id = { type = 13016 id = 609 }
	location = 988 #Freetown
	base = 988
	division = { id = { type = 13016 id = 610 } name = "HMS Neptune" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 613 } name = "HMS Danae" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 614 } name = "HMS Durban" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 615 } name = "HMS Exeter" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 616 } name = "HMS Ajax" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 617 } name = "HMS Cumberland" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 611 } name = "HMS Despatch" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 612 } name = "HMS Dauntless" type = light_cruiser model = 0 }
	division = { id = { type = 13016 id = 578 } name = "26th Destroyer Flotilla" type = destroyer model = 0 }
	division = { id = { type = 13016 id = 618 } name = "27th Destroyer Flotilla" type = destroyer model = 0 }
	}

navalunit = {
	name = "America and West Indies Station"
	id = { type = 13016 id = 619 }
	location = 538 #Bermuda
	base = 538
	division = { id = { type = 13016 id = 620 } name = "HMS Berwick" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 621 } name = "HMS Orion" type = light_cruiser model = 2 }
	division = { id = { type = 13016 id = 622 } name = "HMS York" type = heavy_cruiser model = 1 }
	}

navalunit = {
	name = "China Station"
	id = { type = 13016 id = 623 }
	location = 1315 #Hong Kong
	base = 1315
	division = { id = { type = 13016 id = 624 } name = "HMS Eagle" type = carrier model = 1 extra = cag brigade_model = 3 }
	division = { id = { type = 13016 id = 625 } name = "HMS Kent" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 626 } name = "HMS Cornwall" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 627 } name = "HMS Birmingham" type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 628 } name = "HMS Dorsetshire" type = heavy_cruiser model = 1 }
	division = { id = { type = 13016 id = 629 } name = "28th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 630 } name = "29th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 631 } name = "30th Destroyer Flotilla" type = destroyer model = 0 }
	}

navalunit = {
	name = "3rd Submarine Squadron"
	id = { type = 13016 id = 632 }
	location = 1315 #Hong Kong
	base = 1315
	division = { id = { type = 13016 id = 633 } name = "8th Submarine Flotilla" type = submarine model = 2 }
	division = { id = { type = 13016 id = 634 } name = "9th Submarine Flotilla" type = submarine model = 2 }
	}

navalunit = {
	name = "East Indies Station"
	id = { type = 13016 id = 636 }
	location = 1517 #Colombo
	base = 1517
	division = { id = { type = 13016 id = 637 } name = "HMS Gloucester" type = light_cruiser model = 3 }
	division = { id = { type = 13016 id = 639 } name = "HMS Manchester" type = light_cruiser model = 3 }
	}

division_development = {
	name = "HMS Liverpool"
	type = light_cruiser
	model = 3
	cost = 4
	id = { type = 13016 id = 638 } 
	date = { year = 1938 month = october day = 25 }
	}

division_development = {
	name = "HMS King George V"
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 800 }
	date = { year = 1939 month = january day = 1 }
	}

division_development = {
	name = "HMS Prince of Wales"
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 801 }
	date = { year = 1939 month = april day = 1 }
	}

division_development = {
	name = "HMS Duke of York"
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 812 }
	date = { year = 1939 month = may day = 5 }
	}

division_development = {
	name = "HMS Anson"
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 813 }
	date = { year = 1939 month = july day = 20 }
	}

division_development = {
	name = "HMS Howe"
	type = battleship
	model = 3
	cost = 8.5
	id = { type = 13016 id = 814 }
	date = { year = 1939 month = june day = 1 }
	}

division_development = {
	name = "HMS Illustrious"
	type = carrier
	model = 3
	cost = 5.9
	id = { type = 13016 id = 802 }
	date = { year = 1939 month = april day = 27 }
	}

brigade_development = {
	name = "HMS Illustrious CAG"
	type = cag
	model = 3
	cost = 3
	id = { type = 13016 id = 809 }
	date = { year = 1939 month = april day = 27 }
	}

division_development = {
	name = "HMS Victorious"
	type = carrier
	model = 3
	cost = 5.9
	id = { type = 13016 id = 803 }
	date = { year = 1939 month = may day = 4 }
	}

brigade_development = {
	name = "HMS Victorious CAG"
	type = cag
	model = 3
	cost = 3
	id = { type = 13016 id = 810 }
	date = { year = 1939 month = may day = 4 }
	}

division_development = {
	name = "HMS Formidable"
	type = carrier
	model = 3
	cost = 5.9
	id = { type = 13016 id = 804 }
	date = { year = 1939 month = june day = 17 }
	}

brigade_development = {
	name = "HMS Formidable CAG"
	type = cag
	model = 3
	cost = 3
	id = { type = 13016 id = 811 }
	date = { year = 1939 month = june day = 17 }
	}

division_development = {
	name = "HMS Indomitable"
	type = carrier
	model = 3
	cost = 5.9
	id = { type = 13016 id = 815 }
	date = { year = 1939 month = november day = 10 }
	}

brigade_development = {
	name = "HMS Indomitable CAG"
	type = cag
	model = 3
	cost = 3
	id = { type = 13016 id = 816 }
	date = { year = 1939 month = november day = 10 }
	}


airunit = {
		location = 17
		base = 17
	        id = { type = 13016 id = 170 }
		name = "No.1 (Bomber) Group"
			division = { experience = 20
	        	id = { type = 13016 id = 171 }
			name = "No.71 (Bomber) Wing"
			type = tactical_bomber
			model = 1
			strength = 100
			}
			division = { experience = 20
	        	id = { type = 13016 id = 191 }
			name = "No.75 (Bomber) Wing"
			type = tactical_bomber
			model = 1
			strength = 100
			}
			}



airunit = {
		location = 16
		base = 16
        	id = { type = 13016 id = 172 }
		name = "No.2 (Bomber) Group"
			division = { experience = 20
		        id = { type = 13016 id = 173 }
			name = "No.73 (Bomber) Wing"
			type = tactical_bomber
			model = 1
			strength = 100
			}
			division = { experience = 20
		        id = { type = 13016 id = 192 }
			name = "No.74 (Bomber) Wing"
			type = tactical_bomber
			model = 1
			strength = 100
			}
			}

airunit = {
		location = 17
		base = 17
	        id = { type = 13016 id = 174 }
		name = "No.3 (Bomber) Group"
			division = { experience = 20
	        	id = { type = 13016 id = 175 }
			name = "No.71 (Bomber) Wing"
			type = strategic_bomber
			model = 0
			strength = 5
			}
			}

airunit = {
		location = 14
		base = 14
	        id = { type = 13016 id = 193 }
		name = "No.15 Group Coastal Command"
			division = { experience = 20
		        id = { type = 13016 id = 194 }
			name = "No.15 Group Squadrons"
			type = naval_bomber
			model = 0
			}
			}

airunit = {
		location = 20
		base = 20
	        id = { type = 13016 id = 195 }
		name = "No.16 Group Coastal Command"
			division = { experience = 20
		        id = { type = 13016 id = 196 }
			name = "No.16 Group Squadrons"
			type = naval_bomber
			model = 0
			}
			}

airunit = {
		location = 5
	        base = 5
		id = { type = 13016 id = 197 }
		name = "No.18 Group Coastal Command"
			division = { experience = 20
		        id = { type = 13016 id = 198 }
			name = "No.18 Group Squadrons"
			type = naval_bomber
			model = 0
			}
			}

airunit = {
		location = 17
		base = 17
		id = { type = 13016 id = 176 }
		name = "No.4 (Bomber) Group"
			division = { experience = 5
		        id = { type = 13016 id = 177 }
			name = "No.4 Group Squadrons"
			type = strategic_bomber
			model = 0
			strength = 5
			}
			}

	airunit = {
		location = 17
		base = 17
	        id = { type = 13016 id = 178 }
		name = "No.5 (Bomber) Group"
			division = { experience = 5
	        	id = { type = 13016 id = 179 }
			name = "No.5 Group Squadrons"
			type = tactical_bomber
			model = 1
			strength = 20
			}
			}

	airunit = {
		location = 20
		base = 20
        	id = { type = 13016 id = 180 }
		name = "No.11 (Fighter) Group"
			division = { experience = 20
		        id = { type = 13016 id = 181 }
			name = "No.11 Group"
			type = interceptor
			model = 1
			}
			}

	airunit = {
		location = 13
        	base = 13
		id = { type = 13016 id = 182 }
		name = "No.12 (Fighter) Group"
			division = { experience = 20
		        id = { type = 13016 id = 183 }
			name = "No.12 Group Squadrons"
			type = interceptor
			model = 1
			}
			}

	airunit = {
		location = 9
		base = 9
	        id = { type = 13016 id = 184 }
		name = "No.13 (Fighter) Group"
			division = { experience = 35
		        id = { type = 13016 id = 185 }
			name = "No.13 Group Squadrons"
			type = interceptor
			model = 1
			}
			}

	airunit = {
		location = 21
		base = 21
	        id = { type = 13016 id = 199 }
		name = "No.10 (Fighter) Group"
			division = { experience = 35
		        id = { type = 13016 id = 200 }
			name = "No.10 Group Squadrons"
			type = interceptor
			model = 1
			}
			}

	airunit = {
		location = 1866 # Bagdhad (Habbinaya)
		base = 1866
 	       	id = { type = 13016 id = 186 }
		name = "Middle East Air Command"
			division = { experience = 35
		        id = { type = 13016 id = 187 }
			name = "Middle East Group"
			type = tactical_bomber
			model = 1
			}
			}

	airunit = {
		location = 1457
		base = 1457
        	id = { type = 13016 id = 188 }
		name = "India Air Command"
			division = { experience = 35
		        id = { type = 13016 id = 189 }
			name = "Indian Group"
			type = tactical_bomber
			model = 1
			}
			}

airunit = {
	location = 1353 
        base = 1353
	id = { type = 13016 id = 190 }
	name = "Far East Air Command"
		division = { experience = 35
	        id = { type = 13016 id = 201 }
		name = "Far East Group"
		type = tactical_bomber
		model = 1
		}
		}


}


